/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.help;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.util.auimlcvt.help.HelpRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class HelpRecordUtility {
    private static Set helpRecords;

    private HelpRecordUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List parseHelpPluginFile(File pluginFile) {
        ArrayList<HelpRecord> records = new ArrayList<HelpRecord>();
        String location = "";
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(pluginFile));
            while ((s = br.readLine().trim()) != null) {
                StringTokenizer st;
                if (s.startsWith("#location=")) {
                    location = s.substring("#location=".length());
                    int recordsLength = records.size();
                    for (int i = 0; i < recordsLength; ++i) {
                        HelpRecord hr = (HelpRecord)records.get(i);
                        hr.setLocation(location);
                        records.set(i, hr);
                    }
                    continue;
                }
                if (s.equals("") || s.startsWith("#") || (st = new StringTokenizer(s)).countTokens() != 2) continue;
                String fileName = st.nextToken();
                fileName = fileName.replace('/', '.');
                if ((fileName = fileName.replace('\\', '.')).endsWith(".toc")) {
                    fileName = fileName.substring(0, fileName.indexOf(".toc"));
                }
                String status = st.nextToken();
                try {
                    HelpRecord hr = new HelpRecord(location, fileName, status);
                    records.add(hr);
                }
                catch (Exception e) {
                }
            }
            br.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (location.equals("")) {
                records.clear();
            }
        }
        return records;
    }

    private static void loadHelpRecords() {
        String filePath;
        helpRecords = new TreeSet();
        try {
            filePath = BaseFileControl.getFilePath("pluginbooks");
        }
        catch (Throwable t) {
            filePath = "data/plugins/help";
        }
        File pluginDir = new File(filePath);
        File[] helpPlugins = pluginDir.listFiles();
        if (helpPlugins != null) {
            int helpPluginsLength = helpPlugins.length;
            for (int i = 0; i < helpPluginsLength; ++i) {
                List records = HelpRecordUtility.parseHelpPluginFile(helpPlugins[i]);
                helpRecords.addAll(records);
            }
        }
    }

    public static String getHelpFileLocation(String componentName) {
        if (helpRecords == null) {
            HelpRecordUtility.loadHelpRecords();
        }
        Iterator iterator = helpRecords.iterator();
        while (iterator.hasNext()) {
            HelpRecord hr = (HelpRecord)iterator.next();
            if (!componentName.startsWith(hr.getFileName())) continue;
            if (hr.isExcluded()) {
                return "";
            }
            return hr.getLocation();
        }
        return "";
    }

    public static void main(String[] args) {
        HelpRecordUtility.loadHelpRecords();
        Iterator iterator = helpRecords.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }
}

